# Generated by Django 5.1.1 on 2025-03-04 15:14

import django.core.validators
import django.db.models.deletion
import gakusei.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Becas',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nombre', models.CharField(max_length=200)),
                ('descuento', models.PositiveSmallIntegerField()),
                ('tipo_descuento', models.CharField(choices=[('Porcentual', 'Porcentual'), ('Cardinal', 'Cardinal')], default='Porcentual', help_text='<ul><li>PORCENTUAL: Descuento aplicado por porcentuaje. Ej.: 30%</li><li>CARDINAL: Descuento aplicado por una cantidad fija. Ej.: 20$</li></ul>', max_length=10, verbose_name='Tipo de Descuento')),
                ('status', models.CharField(choices=[('Activo', 'Activo'), ('Deshabilitado', 'Desabilitado')], default='Activo', max_length=15)),
            ],
            options={
                'verbose_name_plural': 'Becas',
            },
        ),
        migrations.CreateModel(
            name='Curso',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('modulo', models.CharField(max_length=50, unique=True, verbose_name='Módulo')),
            ],
        ),
        migrations.CreateModel(
            name='DiaDeClase',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('numero', models.PositiveSmallIntegerField(verbose_name='Número de Clase')),
                ('fecha', models.DateField()),
                ('status', models.CharField(choices=[('Impartida', 'Impartida'), ('Suspendida', 'Suspendida'), ('Cancelada', 'Cancelada')], default='Impartida', max_length=10)),
                ('obs', models.TextField(blank=True, verbose_name='Observaciones')),
            ],
        ),
        migrations.CreateModel(
            name='Estudiante',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('Activo', 'Activo'), ('Retirado', 'Retirado')], default='Activo', max_length=10, verbose_name='Status')),
            ],
        ),
        migrations.CreateModel(
            name='MetodosPagos',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('metodo', models.CharField(max_length=255, verbose_name='Método')),
                ('datos', models.TextField(verbose_name='Datos de Pago')),
                ('obs', models.TextField(blank=True, verbose_name='Observaciones')),
            ],
            options={
                'verbose_name': 'Método de Pago',
                'verbose_name_plural': 'Métodos de Pagos',
            },
        ),
        migrations.CreateModel(
            name='Persona',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nacionalidad', models.CharField(choices=[('V', 'Venezolano/a'), ('E', 'Extranjero/a')], db_default='V', default='V', max_length=1)),
                ('cedula', models.PositiveIntegerField(unique=True, validators=[django.core.validators.MinValueValidator(10000), django.core.validators.MaxValueValidator(999999999)], verbose_name='Cédula')),
                ('first_name', models.CharField(max_length=255, verbose_name='Primer Nombre')),
                ('middle_name', models.CharField(blank=True, max_length=255, verbose_name='Segundo Nombre')),
                ('last_name_1', models.CharField(max_length=255, verbose_name='Primer Apellido')),
                ('last_name_2', models.CharField(blank=True, max_length=255, verbose_name='Segundo Apellido')),
                ('personal_email', models.EmailField(max_length=254, verbose_name='Correo Personal')),
                ('telefono', models.CharField(help_text='Ej.: 0424-1234567', max_length=12, validators=[django.core.validators.RegexValidator('^(0414|0424|0412|0416|0426)[-][0-9]{7}$', 'El teléfono debe tener el formato 04XX-1234567')], verbose_name='Teléfono Movil')),
            ],
        ),
        migrations.CreateModel(
            name='Sede',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nombre', models.CharField(max_length=50)),
                ('ubicacion', models.TextField(verbose_name='Ubicación')),
                ('contacto', models.TextField(verbose_name='Formas de Contacto')),
                ('maps', models.URLField(blank=True, max_length=500, verbose_name='Google Maps')),
            ],
        ),
        migrations.CreateModel(
            name='Clase',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('f_inicio', models.DateField(verbose_name='Fecha de Inicio')),
                ('f_cierre', models.DateField(blank=True, null=True, verbose_name='Fecha de Cierre')),
                ('horas_semanales', models.PositiveSmallIntegerField(verbose_name='Horas Semanales')),
                ('precio', models.PositiveSmallIntegerField(verbose_name='Precio ($)')),
                ('individual', models.BooleanField(default=False, verbose_name='Clase Individual')),
                ('status', models.CharField(choices=[('Activa', 'Activo'), ('En Pausa', 'Pausado'), ('Suspendida', 'Suspendido'), ('Terminada', 'Completado')], default='Activa', max_length=10)),
                ('curso', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='clases', to='gakusei.curso')),
                ('sede', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='clases', to='gakusei.sede')),
            ],
        ),
        migrations.CreateModel(
            name='DescuentoEspecial',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('descuento', models.PositiveSmallIntegerField()),
                ('obs', models.TextField(blank=True, verbose_name='Observaciones')),
                ('estudiante', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='_descuento', to='gakusei.estudiante')),
            ],
            options={
                'verbose_name_plural': 'Descuentos Especiales',
            },
        ),
        migrations.CreateModel(
            name='Becados',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('obs', models.TextField(blank=True, verbose_name='Observaciones')),
                ('beca', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='becados', to='gakusei.becas')),
                ('estudiante', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='_beca', to='gakusei.estudiante')),
            ],
            options={
                'verbose_name_plural': 'Becados',
            },
        ),
        migrations.CreateModel(
            name='Asistencias',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('presente', models.BooleanField(default=False)),
                ('dia_clase', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='asistencias', to='gakusei.diadeclase')),
                ('estudiante', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='asistencias', to='gakusei.estudiante')),
            ],
            options={
                'verbose_name_plural': 'Asistencias',
            },
        ),
        migrations.CreateModel(
            name='Horario',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('dia_semana', models.CharField(choices=[('Lunes', 'Lunes'), ('Martes', 'Martes'), ('Miercoles', 'Miercoles'), ('Jueves', 'Jueves'), ('Viernes', 'Viernes'), ('Sábado', 'Sabado'), ('Domingo', 'Domingo')], max_length=10, verbose_name='Dia de la Semana')),
                ('hora_entrada', models.TimeField()),
                ('hora_salida', models.TimeField()),
                ('clase', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='horario', to='gakusei.clase')),
            ],
        ),
        migrations.AddField(
            model_name='diadeclase',
            name='horario',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='dias_de_clase', to='gakusei.horario'),
        ),
        migrations.CreateModel(
            name='Pagos',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('monto_pagado', models.PositiveSmallIntegerField(validators=[django.core.validators.MinValueValidator(1)])),
                ('referencia', models.CharField(max_length=255)),
                ('fecha', models.DateTimeField(auto_now_add=True, verbose_name='Fecha de Pago')),
                ('obs', models.TextField(blank=True, verbose_name='Observaciones')),
                ('clase', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pagos', to='gakusei.clase')),
                ('estudiante', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pagos', to='gakusei.estudiante')),
                ('metodo', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pagos', to='gakusei.metodospagos')),
            ],
            options={
                'verbose_name': 'Pago',
                'verbose_name_plural': 'Pagos',
            },
        ),
        migrations.AddField(
            model_name='estudiante',
            name='personal_data',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='estudiante', to='gakusei.persona'),
        ),
        migrations.CreateModel(
            name='Representante',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('personal_data', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='representante', to='gakusei.persona')),
            ],
        ),
        migrations.AddField(
            model_name='estudiante',
            name='representante',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='gakusei.representante'),
        ),
        migrations.CreateModel(
            name='Sensei',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('institucional_email', models.EmailField(max_length=254, verbose_name='Correo Institucional')),
                ('EN_level', models.CharField(choices=[('A1', 'A1'), ('A2', 'A2'), ('B1', 'B1'), ('B2', 'B2'), ('C1', 'C1'), ('C2', 'C2')], default='B1', max_length=2, verbose_name='Nivel de Inglés')),
                ('JP_level', models.CharField(choices=[('N5', 'N5'), ('N4', 'N4'), ('N3', 'N3'), ('N2', 'N2'), ('N1', 'N1')], default='N4', max_length=2, verbose_name='Nivel de Japonés')),
                ('status', models.CharField(choices=[('Activo', 'Activo'), ('Retirado', 'Retirado')], default='Activo', max_length=10, verbose_name='Status')),
                ('personal_data', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='sensei', to='gakusei.persona')),
            ],
        ),
        migrations.AddField(
            model_name='clase',
            name='sensei',
            field=models.ForeignKey(on_delete=models.SET(gakusei.models.Clase.sensei_eliminado), related_name='clases', to='gakusei.sensei'),
        ),
        migrations.CreateModel(
            name='Solvencias',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mes', models.DateField()),
                ('pagado', models.CharField(choices=[('Pagado', 'Pagado'), ('Abonado', 'Abonado'), ('Sin Pagar', 'Sin Pagar')], default='Sin Pagar', max_length=10)),
                ('monto_a_pagar', models.PositiveSmallIntegerField()),
                ('monto_abonado', models.PositiveSmallIntegerField(default=0)),
                ('obs', models.TextField(blank=True, verbose_name='Observaciones')),
                ('clase', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='solvencias', to='gakusei.clase')),
                ('estudiante', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='solvencias', to='gakusei.estudiante')),
            ],
            options={
                'verbose_name': 'Solvencia',
                'verbose_name_plural': 'Solvencias',
            },
        ),
        migrations.CreateModel(
            name='Comprobantes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('monto_aplicado', models.PositiveSmallIntegerField()),
                ('pagos', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comprobantes', to='gakusei.pagos')),
                ('solvencias', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comprobantes', to='gakusei.solvencias')),
            ],
            options={
                'verbose_name': 'Comprobante',
                'verbose_name_plural': 'Comprobantes',
            },
        ),
        migrations.CreateModel(
            name='Inscripciones',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('precio_a_pagar', models.PositiveSmallIntegerField(verbose_name='Precio a pagar (en $)')),
                ('clase', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='inscripciones', to='gakusei.clase')),
                ('estudiante', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='inscripciones', to='gakusei.estudiante')),
            ],
            options={
                'verbose_name': 'Inscripción',
                'verbose_name_plural': 'Inscripciones',
                'constraints': [models.UniqueConstraint(fields=('clase', 'estudiante'), name='unique_inscripcion_clase_estudiante')],
            },
        ),
        migrations.AddConstraint(
            model_name='solvencias',
            constraint=models.UniqueConstraint(fields=('estudiante', 'clase', 'mes'), name='unique_mes_solvencia'),
        ),
    ]
